import { Camera, Mail, Phone, MapPin, Clock, Instagram, Youtube, Facebook } from 'lucide-react'
import './Footer.css'

const Footer = () => {
  return (
    <footer className="footer">
      <div className="container">
        <div className="footer-content">
          <div className="footer-section">
            <div className="footer-logo">
              <Camera size={36} strokeWidth={2.5} className="footer-logo-icon" />
              <h2 className="footer-logo-text">PhotoMaster</h2>
            </div>
            <p className="footer-description">
              Профессиональные онлайн-курсы по цифровой фотографии. 
              Обучайтесь у лучших фотографов и развивайте свои навыки.
            </p>
            <div className="footer-social">
              <a href="#" className="social-link">
                <Instagram size={24} strokeWidth={2} />
              </a>
              <a href="#" className="social-link">
                <Youtube size={24} strokeWidth={2} />
              </a>
              <a href="#" className="social-link">
                <Facebook size={24} strokeWidth={2} />
              </a>
            </div>
          </div>
          <div className="footer-section">
            <h3 className="footer-title">Контакты</h3>
            <ul className="footer-links">
              <li>
                <Phone size={20} strokeWidth={2} />
                <a href="tel:+79991234567">+7 (999) 123-45-67</a>
              </li>
              <li>
                <Mail size={20} strokeWidth={2} />
                <a href="mailto:info@photomaster.ru">info@photomaster.ru</a>
              </li>
              <li>
                <MapPin size={20} strokeWidth={2} />
                <span>г. Москва, ул. Фотографическая, д. 8</span>
              </li>
            </ul>
          </div>
          <div className="footer-section">
            <h3 className="footer-title">Уровни курсов</h3>
            <ul className="footer-links">
              <li><a href="#">Начинающий</a></li>
              <li><a href="#">Продвинутый</a></li>
              <li><a href="#">Профессиональный</a></li>
              <li><a href="#">Ретушь</a></li>
            </ul>
          </div>
          <div className="footer-section">
            <h3 className="footer-title">Режим работы</h3>
            <ul className="footer-links">
              <li>
                <Clock size={18} strokeWidth={2} />
                <span>Пн-Вс: 9:00 - 21:00</span>
              </li>
            </ul>
            <div className="footer-cta">
              <p>Начните обучение прямо сейчас</p>
              <a href="/enroll" className="footer-cta-button">Записаться</a>
            </div>
          </div>
        </div>
        <div className="footer-bottom">
          <p>&copy; 2025 PhotoMaster. Все права защищены.</p>
        </div>
      </div>
    </footer>
  )
}

export default Footer

